//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Outlaws
//  Copyright (C) 2016 RETROBYTES PRODUCTIONS
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------


#include "game.h"

//const u8 G_graphics_palette[16] = { 0x10, 0x0D, 0x1A, 0x19, 0x03, 0x0F, 0x06, 0x01, 0x0B, 0x17, 0x0C, 0x09, 0x15, 0x04, 0x08, 0x00};
const u8 G_graphics_palette[16] = { 0x47, 0x40, 0x4b, 0x43, 0x5c, 0x4e, 0x4c, 0x44, 0x57, 0x5b, 0x5e, 0x56, 0x5a, 0x58, 0x4d, 0x54 };

CPCT_ABSOLUTE_LOCATION_AREA(0x8000);

//PALETTES
const u8 G_black_palette[16] = { 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54};

#define G_HUD_0_W 40
#define G_HUD_0_H 64
#define G_HUD_1_W 40
#define G_HUD_1_H 64

const u8 G_hud_0[40 * 64] = {
	0xff, 0xfa, 0xfa, 0xf0, 0xf5, 0xf5, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf5, 0xf5, 0xf0, 0xf0, 0xf5, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf5, 0xf0, 0xfa, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
	0xff, 0xb0, 0xb0, 0xba, 0xba, 0xba, 0xff, 0xff, 0xba, 0xba, 0xff, 0xff, 0xba, 0xba, 0xff, 0xff, 0xba, 0xfa, 0xfa, 0xff, 0xba, 0xfa, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0x70, 0x30, 0xb0, 0x75, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xfa, 0x70, 0x75, 0x75, 0x75, 0x75, 0x75, 0xd5, 0x75, 0x75, 0x75, 0xd5, 0x75, 0x75, 0x75, 0xd5, 0x75, 0x75, 0x75, 0xd5, 0xff, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0xff, 0xff, 0xff, 0xfa, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
	0xff, 0xf5, 0xba, 0xba, 0xba, 0xba, 0xff, 0x5d, 0xba, 0xba, 0xff, 0x5d, 0xba, 0xba, 0xff, 0x5d, 0xba, 0xba, 0xff, 0x5d, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xe4, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x3c, 0xcc,
	0xff, 0x70, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf5, 0x75, 0xff, 0xf0, 0xf0, 0xcc, 0x9c, 0xcc, 0x6c, 0xcc, 0xcc, 0x6c, 0xcc, 0x3c, 0x6c, 0x3c, 0x3c,
	0xfa, 0xfa, 0x30, 0x30, 0x30, 0x30, 0x30, 0xb0, 0x30, 0x30, 0x30, 0xb0, 0x30, 0x30, 0x30, 0xb0, 0x30, 0x30, 0x30, 0xb0, 0x30, 0x30, 0x30, 0xb0, 0xff, 0xe4, 0x9c, 0x3c, 0xcc, 0x9c, 0x3c, 0x3c, 0xcc, 0x6c, 0x3c, 0x3c, 0x3c, 0x6c, 0x3c, 0x3c,
	0xba, 0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0xb0, 0x30, 0x30, 0x30, 0xb0, 0x30, 0x30, 0x30, 0xb0, 0x30, 0x30, 0x30, 0xb0, 0x30, 0x30, 0x30, 0xf5, 0xfa, 0xcc, 0x3c, 0x3c, 0x6c, 0x9c, 0x3c, 0x3c, 0x3c, 0x6c, 0x3c, 0x3c, 0x3c, 0x6c, 0x3c, 0x3c,
	0x30, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xb0, 0xfa, 0xcc, 0x3c, 0x3c, 0x6c, 0x9c, 0x3c, 0x3c, 0x3c, 0x6c, 0x3c, 0x3c, 0x3c, 0x6c, 0x3c, 0x3c,
	0xb0, 0x30, 0xbb, 0x33, 0x33, 0x33, 0x77, 0xf5, 0x33, 0x33, 0xff, 0xf5, 0x33, 0x33, 0xff, 0xf5, 0x33, 0x33, 0xff, 0xf5, 0x33, 0x33, 0x77, 0x75, 0xfa, 0x9c, 0x3c, 0x3c, 0x3c, 0x9c, 0x3c, 0x3c, 0x3c, 0x6c, 0x3c, 0x3c, 0x3c, 0x6c, 0x94, 0x3c,
	0xb0, 0xfa, 0x26, 0x0c, 0xae, 0xae, 0x0c, 0xa4, 0x0c, 0x0c, 0x5d, 0xa4, 0x0c, 0x0c, 0x5d, 0xa4, 0x0c, 0x0c, 0x5d, 0xa4, 0x0c, 0x0c, 0x19, 0xb0, 0xfa, 0x9c, 0x3c, 0x3c, 0x3c, 0x9c, 0x3c, 0x3c, 0x3c, 0x6c, 0x3c, 0x3c, 0x3c, 0x6c, 0x60, 0x3c,
	0xb0, 0x30, 0x26, 0x5d, 0xff, 0xff, 0x0c, 0x24, 0x5d, 0xae, 0x5d, 0x24, 0x5d, 0xae, 0x5d, 0x24, 0x5d, 0xae, 0x5d, 0x24, 0x5d, 0xae, 0x19, 0x75, 0xfa, 0x9c, 0x3c, 0x3c, 0x3c, 0x9c, 0x3c, 0x3c, 0x3c, 0x6c, 0x3c, 0x3c, 0x3c, 0x2c, 0x98, 0x3c,
	0xfa, 0xba, 0x26, 0xea, 0xea, 0xea, 0xae, 0xa4, 0xea, 0xd5, 0x5d, 0xa4, 0xea, 0xd5, 0x5d, 0xa4, 0xea, 0xd5, 0x5d, 0xa4, 0xea, 0xd5, 0x19, 0x30, 0xfa, 0x9c, 0x3c, 0x94, 0x3c, 0xc8, 0x3c, 0x94, 0x3c, 0x6c, 0x3c, 0x94, 0x68, 0x6c, 0x4c, 0x3c,
	0xb0, 0x70, 0x8e, 0xae, 0xae, 0xae, 0x84, 0x24, 0xae, 0x5d, 0x5d, 0x24, 0xae, 0x5d, 0x5d, 0x24, 0xae, 0x5d, 0x5d, 0x24, 0xae, 0x5d, 0x4d, 0xf5, 0xfa, 0x9c, 0x68, 0x60, 0x3c, 0x98, 0x3c, 0x60, 0x3c, 0xc4, 0xc0, 0x34, 0x38, 0x2c, 0x8c, 0x3c,
	0xb0, 0xba, 0x26, 0xd5, 0xff, 0xff, 0x0c, 0x24, 0xae, 0x5d, 0x5d, 0x24, 0xae, 0x5d, 0x5d, 0x24, 0xae, 0x5d, 0x5d, 0x24, 0xae, 0x5d, 0x19, 0x30, 0xfa, 0x9c, 0x38, 0x18, 0x3c, 0x4c, 0x3c, 0x18, 0x3c, 0x64, 0x30, 0x1c, 0x2c, 0x64, 0x4c, 0x3c,
	0xfa, 0x30, 0x8e, 0x48, 0xea, 0xea, 0xae, 0x24, 0xae, 0x5d, 0x5d, 0x24, 0xae, 0x5d, 0x5d, 0x24, 0xae, 0x5d, 0x5d, 0x24, 0xae, 0x5d, 0x4d, 0x75, 0xfa, 0x9c, 0x2c, 0x8c, 0x3c, 0x8c, 0x3c, 0x8c, 0x3c, 0x8c, 0x8c, 0x9c, 0x2c, 0x8c, 0x8c, 0x3c,
	0xba, 0xba, 0x8e, 0xae, 0xae, 0xae, 0xae, 0xa4, 0xae, 0x5d, 0x5d, 0xa4, 0xae, 0x5d, 0x5d, 0xa4, 0xae, 0x5d, 0x5d, 0xa4, 0xae, 0x5d, 0x4d, 0x30, 0xfa, 0x9c, 0x6c, 0x4c, 0x3c, 0x4c, 0x3c, 0x4c, 0x3c, 0x4c, 0x4c, 0x1c, 0x6c, 0x4c, 0x4c, 0x3c,
	0xfa, 0x30, 0x8e, 0xd5, 0xff, 0xff, 0x84, 0x24, 0xd5, 0xea, 0x5d, 0x24, 0xd5, 0xea, 0x5d, 0x24, 0xd5, 0xea, 0x5d, 0x24, 0xd5, 0xea, 0x4d, 0x75, 0xfa, 0x9c, 0x2c, 0x8c, 0x3c, 0x8c, 0x3c, 0x8c, 0x3c, 0x8c, 0x8c, 0x9c, 0x2c, 0x0c, 0x0c, 0x3c,
	0xfa, 0xba, 0x8e, 0x48, 0xea, 0xea, 0x0c, 0x24, 0x48, 0x84, 0x5d, 0x24, 0x48, 0x84, 0x5d, 0x24, 0x48, 0x84, 0x5d, 0x24, 0x48, 0x84, 0x4d, 0x30, 0xfa, 0x9c, 0x2c, 0x0c, 0x3c, 0x0c, 0x3c, 0x0c, 0x3c, 0x0c, 0x0c, 0x1c, 0x2c, 0x0c, 0x0c, 0x3c,
	0xfa, 0x30, 0x8e, 0x0c, 0x84, 0x84, 0x0c, 0x24, 0x0c, 0x0c, 0x5d, 0x24, 0x0c, 0x0c, 0x5d, 0x24, 0x0c, 0x0c, 0x5d, 0x24, 0x0c, 0x0c, 0x4d, 0x75, 0xfa, 0x9c, 0x2c, 0x0c, 0x3c, 0x2c, 0x3c, 0x2c, 0x3c, 0x2c, 0x0c, 0x1c, 0x3c, 0x0c, 0x1c, 0x3c,
	0xff, 0xba, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0x65, 0xcf, 0xcf, 0xdf, 0x65, 0xcf, 0xcf, 0xdf, 0x65, 0xcf, 0xcf, 0xdf, 0x65, 0xcf, 0xcf, 0xcf, 0x30, 0xfa, 0x9c, 0x3c, 0x0c, 0x3c, 0x94, 0x3c, 0x94, 0x3c, 0x84, 0x0c, 0x3c, 0x68, 0x0c, 0x48, 0x3c,
	0xfa, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0x75, 0xff, 0xff, 0xff, 0x75, 0xff, 0xff, 0xff, 0x75, 0xff, 0xff, 0xff, 0x75, 0xff, 0xff, 0xff, 0x75, 0xfa, 0x3c, 0x68, 0x1c, 0x3c, 0x48, 0x3c, 0x48, 0x3c, 0x0c, 0x0c, 0x94, 0x2c, 0x0c, 0x0c, 0x3c,
	0xff, 0xba, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xfa, 0x94, 0x2c, 0x48, 0x3c, 0x0c, 0x3c, 0x0c, 0x3c, 0x0c, 0x0c, 0x1c, 0x2c, 0x0c, 0x0c, 0x3c,
	0xfa, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x75, 0xfa, 0x9c, 0x2c, 0x0c, 0x3c, 0x0c, 0x3c, 0x0c, 0x3c, 0x0c, 0x0c, 0x1c, 0x2c, 0x0c, 0x0c, 0x3c,
	0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5d, 0xff, 0xff, 0xff, 0x5d, 0xff, 0xff, 0xff, 0x5d, 0xff, 0xff, 0xff, 0x5d, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x9c, 0x6c, 0x4c, 0x3c, 0x4c, 0x3c, 0x4c, 0x3c, 0x4c, 0x4c, 0x1c, 0x6c, 0x4c, 0x4c, 0x3c,
	0xb0, 0x75, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd5, 0xff, 0xff, 0xff, 0xd5, 0xff, 0xff, 0xff, 0xd5, 0xff, 0xff, 0xff, 0xd5, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x9c, 0x2c, 0x8c, 0x3c, 0x8c, 0x3c, 0x8c, 0x3c, 0x8c, 0x8c, 0x9c, 0x2c, 0x8c, 0x8c, 0x3c,
	0xfa, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xff, 0xff, 0xba, 0xba, 0xff, 0xba, 0xba, 0xff, 0xff, 0xfb, 0xba, 0xff, 0xba, 0xba, 0xba, 0xba, 0x75, 0xfa, 0x9c, 0x6c, 0x4c, 0x3c, 0x4c, 0x3c, 0x4c, 0x3c, 0x4c, 0x4c, 0x1c, 0x6c, 0x4c, 0x1c, 0x3c,
	0xb0, 0x75, 0x70, 0x75, 0x75, 0x75, 0x75, 0x75, 0xff, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0xff, 0xa6, 0xf7, 0x75, 0x75, 0x75, 0x75, 0x75, 0xb0, 0xfa, 0x9c, 0x2c, 0x8c, 0x3c, 0x8c, 0x3c, 0x3c, 0x3c, 0x8c, 0x8c, 0x3c, 0x3c, 0xcc, 0x3c, 0x3c,
	0xfa, 0xba, 0xff, 0x30, 0x30, 0x30, 0x30, 0xba, 0xff, 0xff, 0xff, 0xff, 0xba, 0x30, 0x30, 0x75, 0xe2, 0xf7, 0x30, 0x30, 0xff, 0xba, 0x30, 0xba, 0xfa, 0x9c, 0x3c, 0x1c, 0x3c, 0x4c, 0x3c, 0x3c, 0x3c, 0x4c, 0x4c, 0x3c, 0x3c, 0xcc, 0x3c, 0x3c,
	0xf0, 0x70, 0x30, 0x30, 0x30, 0xff, 0x75, 0x5d, 0xea, 0x48, 0x0c, 0x0c, 0x5d, 0xba, 0x30, 0x30, 0xfb, 0xba, 0x30, 0x30, 0xae, 0xd5, 0x30, 0x75, 0xfa, 0x9c, 0x3c, 0x3c, 0x3c, 0x8c, 0x3c, 0x3c, 0x3c, 0xcc, 0xcc, 0x3c, 0x3c, 0xcc, 0x3c, 0x3c,
	0xb0, 0x75, 0x30, 0x30, 0x75, 0x0c, 0xae, 0xff, 0x5d, 0xff, 0xff, 0xff, 0xea, 0xd5, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xea, 0xff, 0x30, 0xfa, 0x9c, 0x3c, 0x3c, 0x3c, 0xcc, 0x3c, 0x3c, 0x3c, 0xcc, 0xcc, 0x3c, 0x3c, 0xcc, 0x3c, 0x3c,
	0xb0, 0xb0, 0x30, 0x30, 0x75, 0xff, 0x5d, 0xd5, 0xff, 0xc0, 0xc0, 0xc0, 0xae, 0x5d, 0xc0, 0xc0, 0x95, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xfa, 0x9c, 0x3c, 0x3c, 0x3c, 0xcc, 0x3c, 0x3c, 0x3c, 0xcc, 0xcc, 0x3c, 0x3c, 0xcc, 0x3c, 0x3c,
	0xfa, 0xba, 0xb0, 0x30, 0x30, 0xff, 0xae, 0xea, 0xd5, 0xae, 0x0c, 0x0c, 0xea, 0xd5, 0x84, 0x84, 0x1d, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xba, 0xfa, 0x9c, 0x3c, 0x3c, 0x3c, 0xee, 0x3c, 0x3c, 0x3c, 0xcc, 0xcc, 0x3c, 0x3c, 0xcc, 0x3c, 0x3c,
	0xff, 0xb0, 0xba, 0x30, 0x30, 0x30, 0xff, 0x84, 0x5d, 0x0c, 0x0c, 0x0c, 0xea, 0xd5, 0xc0, 0xc0, 0xd1, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xff, 0xd8, 0x9c, 0x3c, 0x3c, 0x7d, 0x5d, 0x3c, 0x3c, 0x3c, 0xcc, 0xcc, 0x3c, 0x3c, 0xcc, 0x68, 0xc0,
	0xff, 0xb0, 0x30, 0x30, 0xba, 0x30, 0xff, 0x84, 0x5d, 0xc0, 0xc0, 0xc0, 0xea, 0xd5, 0xc0, 0xc0, 0xd1, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xba, 0xfa, 0xc8, 0x3c, 0x3c, 0xae, 0x48, 0xbe, 0x3c, 0x68, 0xcc, 0xcc, 0x68, 0x94, 0xcc, 0x90, 0x30,
	0xfa, 0x30, 0x30, 0x75, 0xf7, 0x30, 0x75, 0x48, 0xd5, 0xc0, 0xff, 0xff, 0xea, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x98, 0x94, 0x3c, 0xea, 0xc0, 0xea, 0xc0, 0x90, 0xcc, 0xcc, 0x90, 0x60, 0xcc, 0x64, 0xcc,
	0xb0, 0x70, 0x30, 0xfb, 0x59, 0xba, 0x75, 0x48, 0xd5, 0xd5, 0xff, 0xff, 0xae, 0xff, 0xd5, 0xc0, 0x95, 0xd5, 0xd5, 0xc0, 0xc0, 0xff, 0xff, 0x30, 0xfa, 0xcc, 0x60, 0xc0, 0x75, 0xd5, 0x98, 0x30, 0x64, 0xcc, 0xcc, 0x64, 0x98, 0xcc, 0xcc, 0xcc,
	0xb0, 0x75, 0x30, 0xae, 0xc0, 0xba, 0x75, 0xc0, 0xd5, 0x84, 0xff, 0xff, 0xea, 0x5d, 0xd5, 0x84, 0x59, 0x5d, 0xd5, 0x84, 0x0c, 0xba, 0x30, 0x75, 0xfa, 0xcc, 0x98, 0x30, 0xdd, 0xdd, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xff, 0xff, 0xff, 0xff,
	0xfa, 0x30, 0x30, 0xfb, 0xd1, 0xba, 0x75, 0xc0, 0xd5, 0xc0, 0x0c, 0x0c, 0xea, 0xd5, 0x5d, 0xff, 0xfb, 0xff, 0x5d, 0xff, 0xff, 0xba, 0x30, 0x30, 0xfa, 0xcc, 0xcc, 0xcc, 0xee, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xf0, 0xf0, 0x30, 0x75, 0xf7, 0x75, 0xff, 0x48, 0xd5, 0xea, 0xc0, 0xc0, 0xea, 0xd5, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0x30, 0x30, 0x75, 0xfa, 0xcc, 0xff, 0xff, 0xee, 0x8d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x30, 0x30, 0x30,
	0xff, 0xff, 0xb0, 0x30, 0xff, 0xba, 0xc0, 0xea, 0xd5, 0x48, 0xc0, 0xc0, 0xea, 0xff, 0xba, 0x75, 0xa6, 0xf7, 0xba, 0x30, 0x30, 0x30, 0x70, 0x30, 0xfa, 0xff, 0xff, 0xff, 0xee, 0x8d, 0xfa, 0x30, 0x30, 0x30, 0x30, 0x75, 0x30, 0x30, 0xb0, 0xb0,
	0xfa, 0xf0, 0xf0, 0xf0, 0xbf, 0x70, 0xd5, 0xd5, 0xff, 0xc0, 0xc0, 0xc0, 0xea, 0xff, 0xfa, 0xf5, 0xe2, 0xf7, 0xf0, 0xd0, 0xf0, 0xf0, 0xf5, 0xf0, 0xff, 0xf0, 0xf0, 0xf5, 0x8d, 0x0f, 0x5f, 0xf0, 0xf0, 0xf5, 0xf0, 0xf0, 0xf5, 0xf0, 0xfa, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xbf, 0xb0, 0x24, 0xc0, 0xd5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0x5d, 0xff, 0xff, 0xff, 0xff, 0xae, 0xff, 0xff, 0xff, 0x5f, 0xff, 0x5f, 0xff, 0xff, 0xae, 0xff, 0xff, 0xae, 0xff, 0xff, 0xff,
	0xff, 0xf0, 0xf5, 0xf5, 0x30, 0x3a, 0x60, 0xd5, 0xff, 0xff, 0x5d, 0xd5, 0xf5, 0xf5, 0xfa, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf5, 0x0c, 0xd5, 0xff, 0xaf, 0xee, 0xcc, 0xaf, 0xff, 0xff, 0x0c, 0xd5, 0xf5, 0x0c, 0xd5, 0xff, 0xaf,
	0xf0, 0x30, 0x70, 0xba, 0x30, 0x3a, 0x75, 0xea, 0x48, 0xd5, 0xae, 0xff, 0xfa, 0xba, 0xfa, 0x30, 0x30, 0x30, 0x30, 0xb0, 0x30, 0x30, 0x30, 0xf5, 0xc0, 0xc4, 0xcc, 0x8d, 0xcc, 0xcc, 0x8d, 0xcc, 0xcc, 0xc0, 0xd5, 0x75, 0xc0, 0xc4, 0xcc, 0x8d,
	0xb0, 0x30, 0x30, 0xba, 0xb0, 0x71, 0x30, 0x84, 0xea, 0xff, 0xea, 0xff, 0x75, 0x75, 0x70, 0x30, 0x30, 0x30, 0x30, 0xb0, 0x30, 0x30, 0x30, 0xb0, 0xea, 0xee, 0xee, 0x0f, 0xcc, 0xcc, 0xcc, 0x4e, 0xee, 0xea, 0xba, 0xba, 0xea, 0xee, 0xee, 0x0f,
	0xfa, 0xb0, 0x30, 0xba, 0xb0, 0x35, 0x30, 0xd5, 0xea, 0xff, 0xea, 0xba, 0xba, 0xba, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xf5, 0x75, 0xaf, 0xcc, 0x4e, 0x4e, 0xcc, 0xcc, 0x0f, 0x8d, 0xff, 0x75, 0x75, 0x75, 0xaf, 0xcc, 0x4e,
	0xff, 0xfa, 0x75, 0x70, 0x30, 0x30, 0xf7, 0xea, 0xea, 0xff, 0xea, 0xff, 0x30, 0x75, 0x30, 0xbb, 0x33, 0x33, 0xff, 0xf5, 0x33, 0x33, 0x77, 0x30, 0xba, 0xff, 0xaf, 0xdd, 0x0f, 0xcc, 0xcc, 0xee, 0x5f, 0xba, 0xba, 0xba, 0xba, 0xff, 0xaf, 0xdd,
	0xfa, 0xf5, 0x75, 0x70, 0x30, 0x30, 0xf7, 0xff, 0xd5, 0xd5, 0xd5, 0xba, 0x30, 0xba, 0xfa, 0x26, 0x0c, 0x0c, 0x5d, 0xa4, 0x0c, 0x0c, 0x19, 0xf5, 0x75, 0x75, 0xaf, 0x0f, 0x4e, 0x4e, 0xcc, 0x0f, 0x5f, 0x30, 0x75, 0x75, 0x75, 0x75, 0xaf, 0x0f,
	0xb0, 0x30, 0x75, 0x24, 0x90, 0x30, 0xff, 0xff, 0xd5, 0xff, 0x5d, 0xba, 0x75, 0x30, 0x30, 0x26, 0x5d, 0xae, 0x5d, 0x24, 0x5d, 0xae, 0x19, 0x30, 0xff, 0xba, 0xff, 0x5f, 0x0f, 0x8d, 0xcc, 0xaf, 0xff, 0xba, 0xba, 0x30, 0x30, 0x30, 0xff, 0x5f,
	0xfa, 0x70, 0xba, 0x48, 0x75, 0x30, 0xbf, 0xf7, 0xea, 0x0c, 0xff, 0x30, 0xba, 0x30, 0xba, 0x26, 0xea, 0xd5, 0x5d, 0xa4, 0xea, 0xd5, 0x19, 0x75, 0x70, 0x75, 0x75, 0x5f, 0x8d, 0x4e, 0x4e, 0xaf, 0xff, 0x75, 0x30, 0x30, 0x30, 0x75, 0x75, 0x5f,
	0xb0, 0x75, 0xba, 0x18, 0xd5, 0x75, 0xfb, 0x59, 0xff, 0xff, 0xff, 0x78, 0xb0, 0x30, 0x70, 0x8e, 0xae, 0x5d, 0x5d, 0x24, 0xae, 0x5d, 0x4d, 0xb0, 0xff, 0xba, 0xff, 0x8d, 0x0f, 0x0f, 0x8d, 0x4e, 0xba, 0xba, 0x30, 0x30, 0x30, 0x30, 0xff, 0x8d,
	0xb0, 0xb0, 0xba, 0xf5, 0xba, 0x75, 0xae, 0xc0, 0xff, 0xff, 0xbe, 0xf0, 0xf0, 0x30, 0xba, 0x26, 0xae, 0x5d, 0x5d, 0x24, 0xae, 0x5d, 0x19, 0x75, 0x75, 0x75, 0x75, 0xcc, 0xee, 0x0f, 0x5f, 0xcc, 0xff, 0x30, 0x30, 0x70, 0x30, 0x30, 0x75, 0xcc,
	0xb0, 0xba, 0xba, 0xb0, 0x30, 0x75, 0xfb, 0xd1, 0xba, 0xba, 0x34, 0xbe, 0xfa, 0x30, 0x30, 0x8e, 0xae, 0x5d, 0x5d, 0x24, 0xae, 0x5d, 0x4d, 0x30, 0xba, 0xba, 0xee, 0xcc, 0x5f, 0xff, 0xaf, 0x4e, 0xdd, 0x75, 0x30, 0x75, 0xb0, 0x30, 0xee, 0xcc,
	0xb0, 0x30, 0xfa, 0xb0, 0x30, 0x75, 0xff, 0xf7, 0x75, 0x30, 0x7d, 0x70, 0x75, 0xb0, 0xba, 0x8e, 0xae, 0x5d, 0x5d, 0xa4, 0xae, 0x5d, 0x4d, 0x75, 0xb0, 0x30, 0xee, 0xcc, 0x0f, 0x0f, 0x0f, 0x8d, 0xdd, 0xba, 0xf0, 0x30, 0xba, 0x30, 0xee, 0xcc,
	0xb0, 0x75, 0x70, 0xb0, 0x30, 0x75, 0xff, 0xba, 0xba, 0x75, 0x38, 0x70, 0x30, 0xb0, 0x30, 0x8e, 0xd5, 0xea, 0x5d, 0x24, 0xd5, 0xea, 0x4d, 0x30, 0xba, 0x30, 0xee, 0x8d, 0x5f, 0xff, 0x0f, 0x4e, 0x5f, 0x70, 0xff, 0xb0, 0x30, 0x30, 0xee, 0x8d,
	0xfa, 0x75, 0x70, 0xb0, 0x30, 0x75, 0xff, 0x75, 0x30, 0xba, 0x78, 0x78, 0xf0, 0xb0, 0xba, 0x8e, 0x48, 0x84, 0x5d, 0x24, 0x48, 0x84, 0x4d, 0x75, 0x30, 0x75, 0xcc, 0x8d, 0x5f, 0xff, 0xaf, 0x0f, 0x8d, 0xff, 0xff, 0xfa, 0x30, 0x75, 0xcc, 0x8d,
	0xb0, 0x75, 0x70, 0xb0, 0x30, 0x75, 0xba, 0xb0, 0x75, 0x30, 0xbe, 0xf0, 0xf0, 0xba, 0x30, 0x8e, 0x0c, 0x0c, 0x5d, 0x24, 0x0c, 0x0c, 0x4d, 0x30, 0x30, 0x75, 0xcc, 0x0f, 0xff, 0xff, 0xff, 0x0f, 0x4e, 0xfa, 0xff, 0xff, 0xf0, 0x75, 0xcc, 0x0f,
	0xfa, 0x75, 0x70, 0xb0, 0x30, 0x75, 0xff, 0xba, 0xba, 0x30, 0x75, 0xf5, 0xf5, 0x30, 0xba, 0xcf, 0xcf, 0xcf, 0xdf, 0x65, 0xcf, 0xcf, 0xcf, 0x75, 0x30, 0xee, 0x8d, 0xff, 0x30, 0x30, 0x75, 0xaf, 0x8d, 0xba, 0xf5, 0xb0, 0xff, 0xee, 0x8d, 0xff,
	0xb0, 0x75, 0x70, 0xb0, 0x30, 0x75, 0xff, 0x75, 0x75, 0xb0, 0x30, 0x38, 0x38, 0x30, 0x30, 0xff, 0xff, 0xff, 0xff, 0x75, 0xff, 0xff, 0xff, 0x30, 0x75, 0xdd, 0x5f, 0xba, 0x30, 0x30, 0x30, 0xff, 0x5f, 0xdd, 0x30, 0x30, 0x75, 0xdd, 0x5f, 0xba,
	0xb0, 0xba, 0xf0, 0xf0, 0x70, 0x30, 0xff, 0xba, 0xba, 0xba, 0x30, 0xba, 0xba, 0x30, 0xba, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x75, 0x75, 0x8d, 0xff, 0x30, 0x30, 0x30, 0x30, 0x75, 0xaf, 0xdd, 0x30, 0x75, 0x75, 0x8d, 0xff, 0x30,
	0xb0, 0xfa, 0xf5, 0xff, 0xff, 0x70, 0xff, 0x75, 0xb0, 0x30, 0xba, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xae, 0xff, 0xba, 0x30, 0x30, 0xf5, 0x30, 0x30, 0xff, 0xae, 0xba, 0x30, 0xae, 0xff, 0xba, 0x30,
	0xf0, 0xff, 0xba, 0xb0, 0x30, 0xff, 0xff, 0xba, 0xba, 0x30, 0xb0, 0xb0, 0x30, 0x30, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5d, 0xff, 0xff, 0xff, 0xff, 0x0c, 0xd5, 0x30, 0x30, 0x70, 0xba, 0x30, 0x30, 0x75, 0x0c, 0x90, 0x30, 0x0c, 0xd5, 0x30, 0x30,
	0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x75, 0x75, 0x30, 0x70, 0xfa, 0x30, 0x30, 0x75, 0xff, 0xff, 0xff, 0xff, 0xd5, 0xff, 0xff, 0xff, 0xba, 0xc0, 0xd5, 0x30, 0x30, 0xf5, 0xff, 0x30, 0x30, 0x75, 0xc0, 0x90, 0x30, 0xc0, 0xd5, 0x30, 0x70,
	0xf0, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xf0, 0xf0, 0xf0, 0xf5, 0xfa, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xea, 0xfa, 0xf0, 0xf0, 0xf5, 0xfa, 0xf0, 0xf0, 0xf0, 0xea, 0xfa, 0xf0, 0xea, 0xfa, 0xf0, 0xf5
};

// Tile G_hud_1: 80x64 pixels, 40x64 bytes.
const u8 G_hud_1[40 * 64] = {
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xfa, 0xf0, 0xf0, 0xf5, 0xf0, 0xf0, 0xf0, 0xf5, 0xfa, 0xf5, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xfa, 0xfa, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x30, 0x30, 0x70, 0x30, 0x75, 0x30, 0x70, 0x30, 0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xb0, 0xb0, 0x30, 0x30, 0x30, 0x70, 0x70, 0x30, 0x30, 0xf5,
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xba, 0x30, 0x30, 0xfa, 0xba, 0x70, 0x30, 0x30, 0x30, 0x30, 0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xb0, 0x70, 0x30, 0xf0,
	0x78, 0xcc, 0x9c, 0xcc, 0xcc, 0x9c, 0x9c, 0xcc, 0xcc, 0xcc, 0xcc, 0xf0, 0xf0, 0xf0, 0xf5, 0xff, 0xba, 0x75, 0x70, 0xb0, 0x30, 0x30, 0x30, 0x30, 0x75, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x70, 0x75, 0x70, 0xf5,
	0x3c, 0xd9, 0x9c, 0x3c, 0x3c, 0x3c, 0x9c, 0xcc, 0x6c, 0x6c, 0x9c, 0x9c, 0xcc, 0x6c, 0xd8, 0xf0, 0xf5, 0xba, 0xba, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xba, 0x75, 0xff,
	0x3c, 0xa6, 0xb6, 0x3c, 0x3c, 0x3c, 0x9c, 0x3c, 0x6c, 0x3c, 0x3c, 0x9c, 0x3c, 0x6c, 0x9c, 0x3c, 0x9c, 0xf5, 0x75, 0xb0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0x70, 0xf0,
	0x3c, 0xe2, 0xb6, 0x3c, 0x3c, 0x3c, 0x9c, 0x3c, 0x6c, 0x3c, 0x3c, 0x9c, 0x3c, 0x6c, 0x3c, 0x3c, 0x3c, 0xd8, 0xba, 0xba, 0xe4, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xd8, 0x30, 0x70,
	0x3c, 0xd9, 0xc8, 0x3c, 0x3c, 0x68, 0x9c, 0x3c, 0x6c, 0x3c, 0x3c, 0x9c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0xd8, 0xff, 0x30, 0xe4, 0xdd, 0xee, 0xff, 0xcc, 0xee, 0xdd, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcc, 0xd8, 0xfa, 0x70,
	0x68, 0xcc, 0xcc, 0x3c, 0x3c, 0x38, 0x9c, 0x3c, 0x6c, 0x3c, 0x3c, 0x9c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0xd8, 0xba, 0xba, 0xe4, 0xc8, 0xee, 0xea, 0xdd, 0xd5, 0xc8, 0xee, 0xea, 0xea, 0xea, 0xea, 0xea, 0xd5, 0xd5, 0xc0, 0xee, 0xd8, 0x75, 0x75,
	0x90, 0x4c, 0x4c, 0x3c, 0x3c, 0x6c, 0x1c, 0x3c, 0x6c, 0x3c, 0x3c, 0x9c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0xd8, 0xba, 0xf5, 0xe4, 0xcc, 0xee, 0xee, 0xdd, 0xdd, 0xcc, 0xff, 0xee, 0xc4, 0xee, 0xc4, 0xee, 0xdd, 0xdd, 0xcc, 0xee, 0xd8, 0x30, 0x70,
	0x24, 0x8c, 0x8c, 0x3c, 0x3c, 0x2c, 0xc8, 0x3c, 0x6c, 0x3c, 0x3c, 0x9c, 0x3c, 0x3c, 0x3c, 0x3c, 0x3c, 0xd8, 0xba, 0xba, 0xe4, 0xcc, 0xee, 0xee, 0xdd, 0xdd, 0xcc, 0xff, 0xee, 0xcc, 0xee, 0xcc, 0xff, 0xcc, 0xdd, 0xcc, 0xee, 0xd8, 0x30, 0xf5,
	0x4c, 0x4c, 0x4c, 0x3c, 0x3c, 0x6c, 0x18, 0x3c, 0xc4, 0x94, 0x68, 0xc8, 0x3c, 0x94, 0x3c, 0x94, 0x3c, 0xd8, 0xba, 0x30, 0xe4, 0xcc, 0xee, 0xee, 0xdd, 0xff, 0xcc, 0xff, 0xee, 0xcc, 0xee, 0xcc, 0xea, 0xcc, 0xdd, 0xcc, 0xee, 0xd8, 0x30, 0x70,
	0x8c, 0x8c, 0x8c, 0x3c, 0x3c, 0x2c, 0x8c, 0x3c, 0x64, 0x34, 0x38, 0x98, 0x3c, 0x34, 0x68, 0x34, 0x3c, 0xd8, 0xba, 0x30, 0xe4, 0xcc, 0xff, 0xee, 0xdd, 0xd5, 0xcc, 0xee, 0xee, 0xcc, 0xee, 0xcc, 0xee, 0xdd, 0xdd, 0xcc, 0xee, 0xd8, 0x30, 0xf0,
	0x4c, 0x4c, 0x4c, 0x3c, 0x94, 0x6c, 0x4c, 0x3c, 0x4c, 0x1c, 0x6c, 0x4c, 0x3c, 0x1c, 0x38, 0xc8, 0xc0, 0xd8, 0xba, 0x30, 0xe4, 0xcc, 0xea, 0xee, 0xff, 0xdd, 0xff, 0xee, 0xff, 0xdd, 0xff, 0xdd, 0xff, 0xff, 0xff, 0xff, 0xee, 0xd8, 0x30, 0x70,
	0x0c, 0x0c, 0x0c, 0x3c, 0x34, 0x2c, 0x0c, 0x3c, 0x8c, 0x9c, 0x2c, 0x8c, 0x3c, 0x9c, 0x2c, 0x98, 0x30, 0xd8, 0xba, 0x30, 0xe4, 0xcc, 0xc4, 0xc4, 0xc0, 0xc8, 0xc0, 0xc4, 0xc0, 0xc8, 0xc0, 0xc8, 0xc0, 0xc0, 0xc0, 0xc0, 0xcc, 0xd8, 0x70, 0xf0,
	0x0c, 0x0c, 0x0c, 0x3c, 0x1c, 0x2c, 0x0c, 0x3c, 0x0c, 0x1c, 0x6c, 0x1c, 0x6c, 0x1c, 0x6c, 0xcc, 0xcc, 0xd8, 0xba, 0x30, 0xe4, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xd9, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xd8, 0x75, 0xff,
	0x0c, 0x0c, 0x0c, 0x3c, 0x1c, 0x2c, 0x0c, 0x3c, 0x2c, 0x1c, 0x2c, 0x1c, 0x2c, 0x9c, 0x2c, 0xcc, 0xcc, 0xd8, 0xba, 0x30, 0xe4, 0xcc, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xa6, 0xf2, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xcc, 0xd8, 0x70, 0xf5,
	0x2c, 0x0c, 0x0c, 0x3c, 0x1c, 0x3c, 0x0c, 0x1c, 0x2c, 0x3c, 0x2c, 0x1c, 0x6c, 0x1c, 0x6c, 0xcc, 0xcc, 0xd8, 0xba, 0x30, 0xe4, 0xcc, 0xe4, 0xcc, 0xcc, 0xcc, 0xdd, 0x30, 0xe2, 0xb2, 0xba, 0xee, 0xcc, 0xcc, 0xcc, 0xd8, 0xcc, 0xd8, 0x70, 0xff,
	0x84, 0x0c, 0x1c, 0x3c, 0x3c, 0x68, 0x0c, 0x1c, 0x2c, 0x3c, 0x2c, 0x1c, 0x3c, 0x1c, 0x2c, 0xcc, 0xcc, 0xd8, 0xba, 0xb0, 0xe4, 0xcc, 0xe4, 0x4c, 0x4c, 0x4c, 0x5d, 0xb0, 0xf1, 0x75, 0x75, 0xe4, 0x4c, 0x4c, 0x4c, 0xd8, 0xcc, 0xd8, 0x75, 0xff,
	0x0c, 0x0c, 0x48, 0x3c, 0x3c, 0x2c, 0x0c, 0x3c, 0x2c, 0x3c, 0x3c, 0x1c, 0x68, 0x48, 0x3c, 0x3c, 0x6c, 0xd8, 0xfa, 0xff, 0xe4, 0xcc, 0xe4, 0x8c, 0x8c, 0x8c, 0xfa, 0x30, 0x30, 0xff, 0xba, 0xae, 0x8c, 0x8c, 0x8c, 0xd8, 0xcc, 0xd8, 0x70, 0xff,
	0x0c, 0x0c, 0x0c, 0x3c, 0x3c, 0x3c, 0x0c, 0x94, 0x2c, 0x3c, 0x3c, 0x1c, 0x2c, 0x18, 0xc0, 0xc0, 0x3c, 0xd8, 0xff, 0xff, 0xe4, 0xcc, 0xe4, 0x4c, 0x0c, 0x0c, 0xff, 0xff, 0x75, 0x70, 0x75, 0x75, 0x0c, 0x0c, 0x4c, 0xd8, 0xcc, 0xd8, 0xff, 0xff,
	0x4c, 0x4c, 0x1c, 0x3c, 0x94, 0x3c, 0x0c, 0x1c, 0x3c, 0x68, 0x94, 0x3c, 0x2c, 0x0c, 0x30, 0x30, 0x3c, 0xd8, 0xfa, 0xff, 0xe4, 0xcc, 0xe4, 0x8c, 0x5d, 0xff, 0x30, 0x30, 0xfa, 0xff, 0xba, 0xf5, 0x0c, 0x0c, 0x8c, 0xd8, 0xcc, 0xd8, 0x70, 0xff,
	0x9c, 0x2c, 0x9c, 0x3c, 0x34, 0x3c, 0x0c, 0x1c, 0x3c, 0x38, 0x34, 0x3c, 0x2c, 0x0c, 0x8c, 0xcc, 0x3c, 0xd8, 0xba, 0xb0, 0xe4, 0xcc, 0xe4, 0x4c, 0xfa, 0xba, 0x30, 0x75, 0x75, 0xfa, 0xff, 0x70, 0x0c, 0x0c, 0x4c, 0xd8, 0xcc, 0xd8, 0x30, 0xf5,
	0x1c, 0x6c, 0x1c, 0x3c, 0x0c, 0x3c, 0x0c, 0x1c, 0x3c, 0x2c, 0x1c, 0x3c, 0x2c, 0x4c, 0x4c, 0xcc, 0x3c, 0xd8, 0xba, 0x30, 0xe4, 0xcc, 0xe4, 0xdd, 0xf5, 0xf5, 0xff, 0xfa, 0xfa, 0xf5, 0xf5, 0xba, 0xa4, 0x0c, 0x8c, 0xd8, 0xcc, 0xd8, 0xba, 0xf5,
	0x9c, 0x2c, 0x9c, 0x2c, 0x8c, 0x3c, 0x8c, 0x9c, 0x3c, 0x2c, 0x9c, 0x3c, 0x2c, 0x1c, 0x2c, 0xcc, 0x3c, 0xd8, 0xba, 0x30, 0xe4, 0xcc, 0xe4, 0x5d, 0xff, 0xfa, 0xf0, 0xf5, 0xd8, 0xf0, 0xff, 0xba, 0xae, 0x0c, 0x4c, 0xd8, 0xcc, 0xd8, 0x70, 0xf0,
	0x3c, 0x6c, 0x1c, 0x3c, 0x9c, 0x3c, 0x6c, 0x9c, 0x3c, 0x6c, 0x48, 0x3c, 0x6c, 0x1c, 0x6c, 0xcc, 0x3c, 0xd8, 0xfa, 0x30, 0xe4, 0xcc, 0xe4, 0xdd, 0xff, 0xff, 0xff, 0xee, 0xdd, 0xf0, 0xf5, 0xff, 0x70, 0x0c, 0x8c, 0xd8, 0xcc, 0xd8, 0x75, 0xff,
	0x3c, 0x6c, 0x3c, 0x3c, 0x9c, 0x3c, 0x6c, 0x9c, 0x3c, 0xc4, 0x98, 0x3c, 0x2c, 0x9c, 0x2c, 0xcc, 0x3c, 0xd8, 0xff, 0x30, 0xe4, 0xcc, 0xe4, 0x4c, 0xff, 0xff, 0xfa, 0xcc, 0xff, 0xfa, 0xfa, 0xff, 0x75, 0x0c, 0x4c, 0xd8, 0xcc, 0xd8, 0x70, 0x30,
	0x3c, 0x6c, 0x3c, 0x3c, 0x9c, 0x3c, 0x6c, 0x9c, 0x3c, 0x64, 0xcc, 0x3c, 0x6c, 0x1c, 0x3c, 0x3c, 0x3c, 0xd8, 0xba, 0x30, 0xe4, 0xcc, 0xe4, 0x8c, 0x5d, 0xf5, 0xe4, 0xee, 0xee, 0xfa, 0xf0, 0xff, 0x75, 0x0c, 0x8c, 0xd8, 0xcc, 0xd8, 0x30, 0x70,
	0x3c, 0x6c, 0x3c, 0x3c, 0x9c, 0x3c, 0x6c, 0x9c, 0x3c, 0xcc, 0xcc, 0x3c, 0x2c, 0x9c, 0x3c, 0x3c, 0x3c, 0xd8, 0xba, 0xb0, 0xe4, 0xcc, 0xe4, 0x4c, 0x5d, 0xfa, 0xcc, 0xdd, 0xcc, 0xd8, 0xfa, 0xba, 0xff, 0x0c, 0x4c, 0xd8, 0xcc, 0xd8, 0x30, 0x30,
	0x3c, 0x6c, 0x3c, 0x3c, 0x9c, 0x3c, 0x6c, 0x3c, 0x3c, 0xcc, 0xcc, 0x3c, 0x3c, 0x9c, 0x3c, 0x3c, 0x3c, 0xd8, 0xba, 0xba, 0xe4, 0xcc, 0xe4, 0x8c, 0x0c, 0xff, 0xdd, 0xcc, 0xff, 0xd8, 0xf5, 0xff, 0xae, 0x0c, 0x8c, 0xd8, 0xcc, 0xd8, 0x70, 0x70,
	0x3c, 0x6c, 0x3c, 0x3c, 0x9c, 0x3c, 0x6c, 0x3c, 0x3c, 0xcc, 0xcc, 0x3c, 0x3c, 0x9c, 0x3c, 0x3c, 0x3c, 0xd8, 0xba, 0x30, 0xe4, 0xcc, 0xe4, 0x4c, 0x0c, 0xfa, 0xee, 0xcc, 0xff, 0xfa, 0xff, 0xff, 0x0c, 0x0c, 0x4c, 0xd8, 0xcc, 0xd8, 0x75, 0x70,
	0x3c, 0xee, 0x3c, 0x3c, 0x9c, 0x3c, 0x6c, 0x3c, 0x3c, 0xcc, 0xcc, 0x3c, 0x3c, 0xbe, 0x3c, 0x3c, 0x3c, 0xd8, 0xba, 0x30, 0xe4, 0xcc, 0xe4, 0x8c, 0x0c, 0xff, 0xff, 0xee, 0xcc, 0xf0, 0xff, 0xff, 0x0c, 0x0c, 0x8c, 0xd8, 0xcc, 0xd8, 0x30, 0x70,
	0x7d, 0x5d, 0x68, 0x94, 0x9c, 0xc0, 0x6c, 0x3c, 0x3c, 0xcc, 0xcc, 0x3c, 0x7d, 0x5d, 0x3c, 0x3c, 0x3c, 0xd8, 0xba, 0x30, 0xe4, 0xcc, 0xe4, 0x4c, 0x0c, 0xff, 0xf3, 0xf7, 0xfa, 0xf5, 0xf5, 0x3f, 0x0c, 0x0c, 0x4c, 0xd8, 0xcc, 0xd8, 0x70, 0xf5,
	0xae, 0x48, 0xba, 0x60, 0xc8, 0x30, 0xc4, 0x3c, 0x3c, 0xcc, 0xcc, 0x3c, 0xae, 0x48, 0xbe, 0x3c, 0x68, 0xd8, 0xba, 0x30, 0xe4, 0xcc, 0xe4, 0x8c, 0x0c, 0xfb, 0xf3, 0xf3, 0xf7, 0xff, 0xbf, 0xf3, 0x2e, 0x0c, 0x2e, 0xd8, 0xcc, 0xd8, 0x30, 0x70,
	0xea, 0xc0, 0xee, 0x98, 0x98, 0xcc, 0x64, 0xc0, 0xc0, 0xcc, 0xcc, 0xc0, 0xea, 0xc0, 0xbe, 0x3c, 0x90, 0xd8, 0xba, 0x30, 0xa4, 0x8c, 0xe4, 0x4c, 0x1d, 0xf3, 0xb7, 0xb7, 0xf3, 0xf7, 0xff, 0x7b, 0xb7, 0x3f, 0x4c, 0xd8, 0x4c, 0x58, 0x30, 0xf5,
	0xdd, 0xd5, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x30, 0x30, 0xcc, 0xcc, 0x30, 0x75, 0xd5, 0x60, 0xc0, 0x64, 0xd8, 0xba, 0x30, 0xe4, 0x4c, 0xe4, 0x8c, 0x1d, 0xb7, 0xf3, 0xf3, 0x3f, 0xf7, 0xfb, 0xb7, 0xf3, 0xb7, 0x8c, 0xd8, 0x8c, 0xd8, 0x30, 0x70,
	0xff, 0xdd, 0xff, 0xff, 0xff, 0xff, 0xee, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xdd, 0xdd, 0x98, 0x30, 0xcc, 0xd8, 0xba, 0x30, 0xa4, 0x8c, 0xe4, 0x4c, 0x0c, 0x7b, 0xf3, 0xf3, 0xf3, 0xff, 0xff, 0xf3, 0xf3, 0xae, 0x4c, 0xd8, 0x4c, 0x58, 0x30, 0x70,
	0xee, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0xaf, 0xee, 0xcc, 0xcc, 0xd8, 0xba, 0x30, 0xe4, 0x4c, 0xe4, 0x8c, 0x0c, 0x7b, 0xf3, 0xf3, 0xf3, 0xff, 0xff, 0xff, 0xf3, 0x2e, 0x8c, 0xd8, 0x8c, 0xd8, 0x70, 0xf5,
	0xee, 0x8d, 0xba, 0x30, 0x30, 0x30, 0x75, 0xff, 0xff, 0xff, 0xff, 0xff, 0xee, 0x8d, 0xff, 0xff, 0xee, 0xd8, 0xba, 0x30, 0xa4, 0x8c, 0xe4, 0x4c, 0x0c, 0x7b, 0xf3, 0xf3, 0x7b, 0xff, 0xbe, 0xff, 0xff, 0x0c, 0x4c, 0xd8, 0x4c, 0x58, 0x75, 0xfa,
	0xee, 0x8d, 0xba, 0x30, 0x30, 0x30, 0x30, 0x70, 0x30, 0x30, 0x30, 0x30, 0xee, 0x8d, 0xff, 0xff, 0xff, 0xfa, 0xfa, 0x30, 0xa4, 0x0c, 0xe4, 0x8c, 0x0c, 0x7b, 0x7b, 0xf3, 0xf7, 0xff, 0x7d, 0x7d, 0x7d, 0x0c, 0x8c, 0xd8, 0x0c, 0x58, 0x75, 0xf5,
	0x8d, 0x0f, 0x5f, 0xf0, 0xf0, 0xf5, 0xf0, 0xf5, 0xf5, 0xf0, 0xf0, 0xf5, 0x8d, 0x0f, 0x5f, 0xf0, 0xf0, 0xf5, 0xf5, 0xb0, 0xa4, 0x0c, 0xe4, 0x0c, 0x0c, 0x3f, 0xf3, 0xf3, 0xf7, 0xbe, 0xbe, 0xbe, 0xff, 0xae, 0x4c, 0xd8, 0x0c, 0x58, 0x70, 0xff,
	0x5f, 0xff, 0x5f, 0xff, 0xff, 0xae, 0xff, 0xff, 0xae, 0xff, 0xff, 0xff, 0x5f, 0xff, 0x5f, 0xff, 0xff, 0xae, 0xff, 0xfa, 0x0c, 0x58, 0x8c, 0x8c, 0x0c, 0x3f, 0xf3, 0x7b, 0xff, 0xff, 0x7d, 0x7d, 0xbe, 0x3c, 0x8c, 0xa4, 0x0c, 0xf5, 0xff, 0xff,
	0xee, 0xcc, 0xaf, 0xff, 0xff, 0x0c, 0xd5, 0xff, 0x0c, 0xd5, 0xff, 0xaf, 0xee, 0xcc, 0xaf, 0xff, 0xff, 0x0c, 0xd5, 0xfa, 0x0c, 0x58, 0xcc, 0x0c, 0x5d, 0x3d, 0x7b, 0xf7, 0xff, 0xbe, 0xbe, 0xbe, 0x7d, 0x33, 0x7d, 0xa4, 0x0c, 0xf5, 0xf0, 0xff,
	0xcc, 0xcc, 0x8d, 0xcc, 0xcc, 0xc0, 0xd5, 0xf5, 0xc0, 0xc4, 0xcc, 0x8d, 0xcc, 0xcc, 0x8d, 0xcc, 0xcc, 0xc0, 0xd5, 0xf0, 0x0c, 0x58, 0x8c, 0x8c, 0x1c, 0xbe, 0x7b, 0xf7, 0xff, 0x7d, 0x7d, 0x67, 0x9b, 0xcf, 0x67, 0xa4, 0x0c, 0xf5, 0x30, 0xf5,
	0xcc, 0xcc, 0xcc, 0x4e, 0xee, 0xea, 0xba, 0xfa, 0xea, 0xee, 0xee, 0x0f, 0xcc, 0xcc, 0xcc, 0x4e, 0xee, 0xea, 0xfa, 0xfa, 0x0c, 0x58, 0xcc, 0x0c, 0x7d, 0x7d, 0x7b, 0xf7, 0xbe, 0xbe, 0x33, 0x9b, 0x9b, 0x9b, 0x9b, 0xa4, 0x0c, 0xf5, 0x30, 0xf5,
	0x4e, 0xcc, 0xcc, 0x0f, 0x8d, 0xff, 0x75, 0x75, 0x75, 0xaf, 0xcc, 0x4e, 0x4e, 0xcc, 0xcc, 0x0f, 0x8d, 0xff, 0x75, 0x70, 0x0c, 0x58, 0x8c, 0x9c, 0xbe, 0x3c, 0x3d, 0xff, 0x39, 0x33, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xa4, 0x0c, 0xf5, 0x70, 0x70,
	0x0f, 0xcc, 0xcc, 0xee, 0x5f, 0xba, 0xba, 0xba, 0xba, 0xff, 0xaf, 0xdd, 0x0f, 0xcc, 0xcc, 0xee, 0x5f, 0xba, 0xba, 0x70, 0x0c, 0x58, 0xcc, 0x39, 0x9b, 0xcf, 0x9f, 0xbe, 0x33, 0x9b, 0x9b, 0x9b, 0x9b, 0x9b, 0x9b, 0xa4, 0x0c, 0xf5, 0x75, 0x70,
	0x4e, 0x4e, 0xcc, 0x0f, 0x5f, 0x75, 0x75, 0x75, 0x75, 0x75, 0xaf, 0x0f, 0x4e, 0x4e, 0xcc, 0x0f, 0x5f, 0x75, 0x30, 0xfa, 0x0c, 0x58, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xa4, 0x0c, 0xf5, 0x30, 0x70,
	0x0f, 0x8d, 0xcc, 0xaf, 0xff, 0x30, 0xba, 0x30, 0x30, 0xba, 0xff, 0x5f, 0x0f, 0x8d, 0xcc, 0xaf, 0xff, 0xba, 0x75, 0x70, 0x0c, 0x5d, 0x5d, 0x0c, 0x0c, 0x5d, 0xae, 0x0c, 0xff, 0xff, 0x0c, 0x5d, 0xae, 0x0c, 0x5d, 0xae, 0x0c, 0xf5, 0x70, 0x70,
	0x8d, 0x4e, 0x4e, 0xaf, 0xba, 0x75, 0x70, 0xb0, 0x75, 0x75, 0x75, 0x5f, 0x8d, 0x4e, 0x4e, 0xaf, 0xff, 0x30, 0xba, 0xfa, 0x0c, 0xff, 0xff, 0xae, 0x0c, 0xea, 0xd5, 0x0c, 0xea, 0xc0, 0x0c, 0xea, 0xd5, 0x0c, 0xea, 0xd5, 0x0c, 0xf5, 0x75, 0x70,
	0x0f, 0x0f, 0x8d, 0x4e, 0xba, 0xba, 0x75, 0xfa, 0x30, 0x30, 0xff, 0x8d, 0x0f, 0x0f, 0x8d, 0x4e, 0xba, 0x75, 0x75, 0x70, 0x5d, 0x5d, 0x5d, 0x5d, 0x0c, 0x84, 0x5d, 0x0c, 0xae, 0x0c, 0x0c, 0xae, 0x5d, 0x0c, 0xae, 0x5d, 0x0c, 0xf5, 0xb0, 0x70,
	0xee, 0x0f, 0x5f, 0xcc, 0xff, 0x30, 0xf5, 0x30, 0x30, 0x70, 0x75, 0xcc, 0xee, 0x0f, 0x5f, 0xcc, 0xba, 0xba, 0x30, 0xa4, 0x48, 0xff, 0xff, 0xae, 0x0c, 0x5d, 0xea, 0x0c, 0xd5, 0xae, 0x0c, 0xae, 0x5d, 0x0c, 0xae, 0x5d, 0x58, 0xba, 0xba, 0x70,
	0x5f, 0xff, 0xaf, 0x4e, 0xdd, 0x30, 0xba, 0x30, 0x30, 0x30, 0xee, 0xcc, 0x5f, 0xff, 0xaf, 0x4e, 0xdd, 0x30, 0x30, 0xa4, 0x0c, 0xd5, 0xd5, 0xd5, 0x0c, 0xea, 0x84, 0x0c, 0x48, 0xd5, 0x0c, 0xae, 0x5d, 0x0c, 0xae, 0x5d, 0x58, 0xba, 0x30, 0x70,
	0x0f, 0x0f, 0x0f, 0x8d, 0xdd, 0x30, 0x30, 0x30, 0x30, 0x75, 0xee, 0xcc, 0x0f, 0x0f, 0x0f, 0x8d, 0xdd, 0xb0, 0x30, 0xa4, 0x5d, 0x5d, 0x5d, 0x5d, 0x0c, 0xae, 0x0c, 0x0c, 0xae, 0x5d, 0x0c, 0xae, 0x5d, 0x0c, 0xae, 0x5d, 0x58, 0xba, 0x70, 0x70,
	0x5f, 0xff, 0x0f, 0x4e, 0x5f, 0x30, 0x30, 0x30, 0x30, 0x30, 0xee, 0x8d, 0x5f, 0xff, 0x0f, 0x4e, 0x5f, 0xba, 0x30, 0xa4, 0x0c, 0xff, 0xff, 0xae, 0x0c, 0xff, 0xff, 0x0c, 0xd5, 0xea, 0x0c, 0xd5, 0xea, 0x0c, 0xd5, 0xea, 0x58, 0xba, 0x75, 0x70,
	0x5f, 0xff, 0xaf, 0x0f, 0x8d, 0xba, 0x30, 0x30, 0x30, 0x75, 0xcc, 0x8d, 0x5f, 0xff, 0xaf, 0x0f, 0x8d, 0xba, 0xb0, 0xa4, 0x0c, 0x5d, 0x5d, 0x0c, 0x0c, 0xc0, 0xc0, 0x0c, 0x48, 0x84, 0x0c, 0x48, 0x84, 0x0c, 0x48, 0x84, 0x58, 0xba, 0x30, 0x70,
	0xff, 0xff, 0xff, 0x0f, 0x4e, 0xba, 0x30, 0x30, 0x30, 0x75, 0xcc, 0x0f, 0xff, 0xff, 0xff, 0x0f, 0x4e, 0xba, 0xba, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xba, 0x30, 0xf5,
	0x30, 0x30, 0x75, 0xaf, 0x8d, 0xba, 0x30, 0x30, 0x30, 0xee, 0x8d, 0xff, 0x30, 0x30, 0x75, 0xaf, 0x8d, 0xba, 0x30, 0x75, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x30, 0x70,
	0x30, 0x30, 0x30, 0xff, 0x5f, 0xdd, 0x30, 0x30, 0x75, 0xdd, 0x5f, 0xba, 0x30, 0x30, 0x30, 0xff, 0x5f, 0xdd, 0x30, 0x75, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x30, 0xf5,
	0x30, 0x30, 0x30, 0x75, 0xaf, 0xdd, 0x30, 0x30, 0x75, 0x8d, 0xff, 0x30, 0x30, 0x30, 0x30, 0x75, 0xaf, 0xdd, 0x30, 0x75, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x70, 0xf0,
	0x30, 0x30, 0x30, 0x30, 0xff, 0xae, 0xba, 0x30, 0xae, 0xff, 0xba, 0x30, 0x30, 0x70, 0xba, 0x30, 0xff, 0xae, 0xba, 0x30, 0x30, 0xb0, 0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xf5, 0xff,
	0x30, 0x30, 0x30, 0x30, 0x75, 0x0c, 0x90, 0x30, 0x0c, 0xd5, 0x30, 0x30, 0x70, 0x75, 0x70, 0x30, 0x75, 0x0c, 0x90, 0x30, 0x30, 0x30, 0xf5, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xb0, 0x70, 0xff,
	0x70, 0x30, 0x30, 0x30, 0x75, 0xc0, 0x90, 0x30, 0xc0, 0xd5, 0x70, 0x30, 0xba, 0xba, 0xf5, 0xb0, 0x75, 0xc0, 0x90, 0x30, 0x30, 0x30, 0xba, 0x30, 0x30, 0x30, 0x70, 0xb0, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0xba, 0x30, 0xf0,
	0xf5, 0xf0, 0xf0, 0xf0, 0xf0, 0xea, 0xfa, 0xf0, 0xea, 0xfa, 0xf5, 0xf0, 0xf0, 0xf0, 0xff, 0xfa, 0xf0, 0xea, 0xfa, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf5, 0xfa, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xfa, 0xfa, 0xf0, 0xf0, 0xf0, 0xf0
};

const u8 G_RETROBYTES[1344] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xAE, 0x0C, 0x0C, 0x57, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x09, 0xFF, 0x0C, 0x0C,
	0x57, 0xFF, 0xEB, 0x57, 0xEB, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xAE, 0xC3, 0xC3, 0x57, 0x49, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0x83, 0xFF, 0xC3, 0xC3,
	0x57, 0xFF, 0xEB, 0x57, 0xEB, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xAE, 0xC3, 0xC3, 0x83, 0x49, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0x06, 0xC3, 0xC3,
	0x83, 0xFF, 0xFF, 0x83, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xAE, 0xC3, 0xC3, 0x83, 0x49, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0x06, 0xC3, 0xC3,
	0x83, 0xFF, 0xFF, 0x83, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xAE, 0x83, 0xAE, 0x83, 0x49, 0x57, 0xFF, 0xAE, 0x86, 0x49, 0x57, 0x49, 0x06, 0x83, 0xAE,
	0x83, 0xFF, 0xFF, 0xEB, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xAE, 0x83, 0xAE, 0x83, 0x49, 0x57, 0xFF, 0xAE, 0x83, 0x49, 0x57, 0x49, 0x06, 0x83, 0xAE,
	0x83, 0xFF, 0xFF, 0xEB, 0x57, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xAE, 0x86, 0x49, 0x57, 0x49, 0x0C, 0x09, 0xAE, 0x83, 0x49, 0x0C, 0x83, 0xAE, 0x83, 0xAE,
	0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xAE, 0xC3, 0xC3, 0x57, 0x49, 0xC3, 0x83, 0xAE, 0x83, 0x49, 0xC3, 0x83, 0xAE, 0x83, 0xAE,
	0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xAE, 0xC3, 0xC3, 0x83, 0x49, 0x57, 0xFF, 0xAE, 0x83, 0x49, 0xC3, 0xC3, 0x06, 0x83, 0xAE,
	0x83, 0xAE, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x5D, 0xFF, 0xFF,
	0xFF, 0xAE, 0xC3, 0xC3, 0x83, 0x49, 0x57, 0xFF, 0xAE, 0x83, 0x49, 0xC3, 0xC3, 0x06, 0x83, 0xAE,
	0x83, 0xEB, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0xC3, 0x83, 0xFF, 0xFF,
	0xFF, 0xAE, 0x83, 0xAE, 0x83, 0x49, 0x0C, 0x0C, 0x06, 0x83, 0x49, 0x57, 0x49, 0x06, 0x86, 0x49,
	0x83, 0x49, 0x57, 0xFC, 0xFC, 0xC3, 0x43, 0x57, 0xFF, 0xAE, 0x57, 0xFF,
	0xFF, 0xAE, 0x83, 0xAE, 0x83, 0x49, 0xC3, 0xC3, 0x06, 0x83, 0x49, 0x57, 0x49, 0x06, 0xC3, 0xC3,
	0x83, 0xC3, 0x57, 0xA9, 0x03, 0xC3, 0x43, 0x57, 0xFF, 0xEB, 0x57, 0xFF,
	0xFF, 0xAE, 0x83, 0xAE, 0xC3, 0x06, 0xC3, 0xC3, 0x06, 0x83, 0x49, 0x57, 0x49, 0x83, 0x49, 0xC3,
	0x57, 0x83, 0xAE, 0x89, 0xCC, 0xC9, 0x43, 0x06, 0x0C, 0x43, 0x57, 0xFF,
	0xFF, 0xAE, 0x83, 0xAE, 0xC3, 0x06, 0xC3, 0xC3, 0x06, 0x83, 0x49, 0x57, 0x49, 0x83, 0x49, 0xC3,
	0x57, 0x83, 0xAE, 0xA9, 0x03, 0xE9, 0x43, 0x43, 0xC3, 0x43, 0x57, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAE, 0x89, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0x9C, 0x4C, 0xEC, 0x89, 0xCC, 0x6C, 0x57, 0xFF, 0xAE, 0x7D, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAE, 0x9D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0x9C, 0x5C, 0x03, 0x03, 0xEC, 0x6C, 0x57, 0xFF, 0xAE, 0x7D, 0xFF,
	0xFF, 0xAE, 0x0C, 0x0C, 0x7F, 0x0C, 0x7F, 0x0C, 0x2E, 0x9C, 0x0C, 0x0C, 0x0C, 0x7F, 0x0C, 0x0C,
	0x1D, 0x9C, 0x5C, 0x46, 0x46, 0xEC, 0x6C, 0x0C, 0x0C, 0x1D, 0xFF, 0xFF,
	0xFF, 0xAE, 0xCC, 0xCC, 0x7D, 0x4C, 0x7D, 0x4C, 0x2C, 0x9C, 0x4C, 0xCC, 0xCC, 0x7D, 0x4C, 0xCC,
	0x9C, 0x9C, 0x5C, 0x03, 0x03, 0xEC, 0x6C, 0xCC, 0xCC, 0x9C, 0xFF, 0xFF,
	0xFF, 0xAE, 0xCC, 0xCC, 0x9D, 0x4C, 0x7D, 0x4C, 0x2C, 0x9C, 0x4C, 0xCC, 0xCC, 0x2C, 0xCC, 0xCC,
	0x9C, 0x9C, 0xEE, 0x46, 0x03, 0xEC, 0x6C, 0xCC, 0x6E, 0x8C, 0x7F, 0xFF,
	0xFF, 0xAE, 0xCC, 0xCC, 0x9C, 0x4C, 0x7D, 0x4C, 0x2C, 0x9C, 0x4C, 0xCC, 0xCC, 0x2C, 0xCC, 0xCC,
	0x9C, 0x9C, 0xFE, 0x03, 0x03, 0xEC, 0x6C, 0xCC, 0x6C, 0xCC, 0x7D, 0xFF,
	0xFF, 0xAE, 0x9D, 0xAE, 0x9C, 0x4C, 0x0C, 0xCC, 0x2C, 0x9C, 0x4C, 0x7F, 0xFF, 0xAE, 0x9D, 0xFF,
	0xFF, 0x9C, 0xFE, 0x03, 0x03, 0xEC, 0x6C, 0xCC, 0x4C, 0x9D, 0xFF, 0xFF,
	0xFF, 0xAE, 0x9C, 0xAE, 0x9C, 0x4C, 0xCC, 0xCC, 0x2C, 0x9C, 0x4C, 0x7D, 0xFF, 0xAE, 0x9C, 0xFF,
	0xFF, 0x9C, 0xEE, 0x89, 0x03, 0xEC, 0x6C, 0xCC, 0xCC, 0x9C, 0xFF, 0xFF,
	0xFF, 0xAE, 0x8C, 0x4C, 0x7F, 0xEE, 0xCC, 0xCC, 0x2C, 0x9C, 0x4C, 0x0C, 0x1D, 0xAE, 0x8C, 0x0C,
	0x7F, 0x9C, 0xFE, 0x03, 0x03, 0xEC, 0x6C, 0xCC, 0x6E, 0x8C, 0x7F, 0xFF,
	0xFF, 0xAE, 0xCC, 0xCC, 0x7D, 0xEE, 0xCC, 0xCC, 0x2C, 0x9C, 0x4C, 0xCC, 0x9C, 0xFF, 0xCC, 0xCC,
	0x7D, 0x9C, 0xFE, 0x03, 0x03, 0xEC, 0x6C, 0xCC, 0x6C, 0xCC, 0x7D, 0xFF,
	0xFF, 0xAE, 0x9D, 0xAE, 0x9D, 0xFF, 0xFF, 0x4C, 0x2C, 0x9C, 0x4C, 0x7F, 0xFF, 0xFF, 0xFF, 0xAE,
	0x9D, 0x8C, 0x7D, 0xA9, 0x56, 0x4C, 0x6C, 0x9D, 0xFF, 0x9D, 0xFF, 0xFF,
	0xFF, 0xAE, 0x9C, 0xAE, 0x9C, 0xFF, 0xFF, 0x4C, 0x2C, 0x9C, 0x4C, 0x7D, 0xFF, 0xFF, 0xFF, 0xAE,
	0x9C, 0xCC, 0x7D, 0xFC, 0xFC, 0xCC, 0x6C, 0x9C, 0xFF, 0x9C, 0xFF, 0xFF,
	0xFF, 0xAE, 0x8C, 0x4C, 0x9C, 0x0C, 0x0C, 0xCC, 0x2C, 0x9C, 0x4C, 0x0C, 0x0C, 0x2E, 0x0C, 0x4C,
	0x9C, 0xCC, 0x0C, 0x0C, 0x0C, 0xCC, 0x6C, 0x8C, 0x0C, 0x8C, 0x7F, 0xFF,
	0xFF, 0xAE, 0xCC, 0xCC, 0x9C, 0x4C, 0xCC, 0xCC, 0x2C, 0x9C, 0x4C, 0xCC, 0xCC, 0x6C, 0xCC, 0xCC,
	0x9C, 0x8C, 0xCC, 0xCC, 0xCC, 0x4C, 0x6C, 0xCC, 0xCC, 0xCC, 0x7D, 0xFF,
	0xFF, 0xAE, 0xCC, 0xCC, 0x7F, 0x4C, 0xCC, 0x9D, 0xAE, 0x9C, 0x4C, 0xCC, 0xCC, 0x6C, 0xCC, 0xCC,
	0x7F, 0xEE, 0x6E, 0x9D, 0x9D, 0x9D, 0x1D, 0x9D, 0xCC, 0x9D, 0xFF, 0xFF,
	0xFF, 0xAE, 0xCC, 0xCC, 0x7D, 0x4C, 0xCC, 0x9C, 0xAE, 0x9C, 0x4C, 0xCC, 0xCC, 0x6C, 0xCC, 0xCC,
	0x7D, 0xEE, 0x6C, 0x9C, 0x9C, 0x9C, 0x9C, 0x9C, 0xCC, 0x9C, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x0C, 0x0D, 0xAE, 0x0C, 0x5F, 0xAE, 0x0D, 0xAE, 0x0C, 0x5F, 0x0C, 0x0E, 0x5F, 0x0C, 0x5F, 0x0C,
	0x0C, 0x0E, 0x0C, 0x0D, 0xAE, 0x0D, 0xAE, 0x0C, 0x5F, 0xAE, 0x0D, 0xFF,
	0x33, 0x67, 0xBB, 0x33, 0xDF, 0xBB, 0x67, 0xBB, 0x33, 0xDF, 0x33, 0x9B, 0xDF, 0x33, 0xDF, 0x33,
	0x33, 0x9B, 0x33, 0x67, 0xBB, 0x67, 0xBB, 0x33, 0xDF, 0xBB, 0x67, 0xFF,
	0x33, 0x1B, 0x1B, 0x27, 0x27, 0x33, 0x1B, 0x1B, 0x27, 0x27, 0x33, 0x9B, 0x9B, 0x27, 0x27, 0xBB,
	0x27, 0xFF, 0x33, 0x5F, 0x33, 0x1B, 0x1B, 0x27, 0x27, 0x33, 0x1B, 0x5F,
	0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0xBB,
	0x67, 0xFF, 0x33, 0xDF, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0xDF,
	0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0xFF, 0xBB,
	0x67, 0xFF, 0x33, 0xDF, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0xDF, 0xFF,
	0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0xFF, 0xBB,
	0x67, 0xFF, 0x33, 0xDF, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0xDF, 0xFF,
	0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0xFF, 0xBB,
	0x67, 0xFF, 0x33, 0xDF, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0xBB, 0x27, 0xFF,
	0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0xFF, 0xBB,
	0x67, 0xFF, 0x33, 0xDF, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0xBB, 0x67, 0xFF,
	0x33, 0x0D, 0xBB, 0x26, 0x5F, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0xFF, 0xBB,
	0x67, 0xFF, 0x33, 0xDF, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0xFF, 0x33, 0x5F,
	0x33, 0x67, 0xBB, 0x33, 0xDF, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0xFF, 0xBB,
	0x67, 0xFF, 0x33, 0xDF, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0xFF, 0x33, 0xDF,
	0x33, 0x5F, 0xBB, 0x27, 0x27, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0x27, 0xBB,
	0x67, 0xFF, 0x33, 0xDF, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0x27, 0x33, 0xDF,
	0x33, 0xDF, 0xBB, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0xBB,
	0x67, 0xFF, 0x33, 0xDF, 0x33, 0x9B, 0x9B, 0x67, 0x67, 0x67, 0x33, 0xDF,
	0x33, 0xDF, 0xBB, 0x67, 0x67, 0xBB, 0x0D, 0xBB, 0x26, 0x5F, 0xBB, 0x0D, 0xFF, 0x26, 0x5F, 0xBB,
	0x67, 0xAE, 0x33, 0x27, 0xBB, 0x0D, 0xBB, 0x67, 0x67, 0xAE, 0x27, 0xFF,
	0x33, 0xDF, 0xBB, 0x67, 0x67, 0xBB, 0x67, 0xBB, 0x33, 0xDF, 0xBB, 0x67, 0xFF, 0x33, 0xDF, 0xBB,
	0x67, 0xBB, 0x33, 0x67, 0xBB, 0x67, 0xBB, 0x67, 0x67, 0xBB, 0x67, 0xFF};


const u8 G_Presenta[192] = {
	0x0C, 0x0C, 0xFF, 0x0C, 0x0C, 0xFF, 0x0C, 0x0C, 0x5D, 0xAE, 0x0C, 0x5D, 0x0C, 0x0C, 0x5D, 0x5D,
	0xFF, 0x5D, 0x0C, 0x0C, 0x5D, 0xAE, 0x0C, 0xFF,
	0xCC, 0xCC, 0xDD, 0xCC, 0xCC, 0xDD, 0xCC, 0xCC, 0xDD, 0xCC, 0xCC, 0xDD, 0xCC, 0xCC, 0xDD, 0xCC,
	0xFF, 0xDD, 0xCC, 0xCC, 0xDD, 0xCC, 0xCC, 0xDD,
	0x64, 0x30, 0xDD, 0x64, 0x30, 0xDD, 0x64, 0x30, 0xDD, 0x98, 0x30, 0x75, 0x64, 0x30, 0xDD, 0xCC,
	0xDD, 0xDD, 0x30, 0x98, 0x75, 0x98, 0x30, 0xDD,
	0xFA, 0xF0, 0x75, 0xFA, 0xF0, 0xF5, 0xFA, 0xF5, 0x75, 0x70, 0xF0, 0xFF, 0xFA, 0xF5, 0x75, 0xF0,
	0xF0, 0xF5, 0xFF, 0xF5, 0xFF, 0xF0, 0xF0, 0xF5,
	0xFA, 0x30, 0xFF, 0xFA, 0xF0, 0x75, 0xFA, 0x75, 0xF5, 0xBA, 0x30, 0xF5, 0xFA, 0x75, 0xF5, 0xB0,
	0xF0, 0xF5, 0xFF, 0xF5, 0xFF, 0xF0, 0xF0, 0xF5,
	0x3C, 0x7D, 0xFF, 0x3C, 0x34, 0x7D, 0x3C, 0x3C, 0x7D, 0x3C, 0x3C, 0x7D, 0x3C, 0x3C, 0x7D, 0x7D,
	0x34, 0x7D, 0xBE, 0x3C, 0xFF, 0x38, 0x30, 0x7D,
	0x3C, 0x7D, 0xFF, 0x3C, 0xBE, 0x7D, 0x3C, 0x3C, 0x7D, 0x3C, 0x3C, 0x75, 0x3C, 0x3C, 0x7D, 0x7D,
	0xBA, 0x7D, 0xBE, 0x3C, 0xFF, 0x7D, 0xFF, 0x7D,
	0x30, 0x75, 0xFF, 0x30, 0xBA, 0x75, 0x30, 0x30, 0x75, 0x30, 0x30, 0xFF, 0x30, 0x30, 0x75, 0x75,
	0xFF, 0x75, 0xBA, 0x30, 0xFF, 0x75, 0xFF, 0x75};

const u8 G_destello1[28] = {
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00};

const u8 G_destello2[28] = {
	0x00, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x00, 0x00,
	0x08, 0x0C, 0x88, 0x88,
	0x00, 0x44, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x00, 0x00};

void drawDestello(){

	static u16 cycles;
	static u8 rand;
	u8 *pvideo = cpctm_screenPtr(SCR_VMEM, 28, 110);

	if(rand == 0) rand = 26 + cpct_rand() % 24;

	if(cycles == 0 || cycles == 3200){
		cpct_waitVSYNC();
		//eraseClippedSprite(26, 107, 30, 20);
		pvideo = cpctm_screenPtr(SCR_VMEM, 25, 100);
		cpct_drawSolidBox(pvideo, 255, 30,20);
		pvideo = cpctm_screenPtr(SCR_VMEM, 28, 110);
		cpct_drawSprite(G_Presenta, pvideo, 24, 8);
		drawClippedSprite(G_destello1, rand, 107, 4, 7);

	}

	if(cycles == 1600){

		drawClippedSprite(G_destello2, rand, 107, 4, 7);
	}

	if(cycles == 4800){

		cpct_waitVSYNC();
		pvideo = cpctm_screenPtr(SCR_VMEM, 25, 100);
		cpct_drawSolidBox(pvideo, 255, 30,20);
		pvideo = cpctm_screenPtr(SCR_VMEM, 28, 110);
		cpct_drawSprite(G_Presenta, pvideo, 24, 8);

		rand = 0;

		cycles = 0;
	}

	cycles++;

}

void drawHUD() {

	cpct_setPalette(G_black_palette, 16);
	cpct_setBorder(G_black_palette[0]);
	cpct_setVideoMode(0);

    cpct_memset(SCR_VMEM, 255, 0x4000);
    cpct_drawSprite(G_hud_0, cpctm_screenPtr(SCR_VMEM, 0, 200 - G_HUD_0_H), G_HUD_0_W, G_HUD_0_H);
    cpct_drawSprite(G_hud_1, cpctm_screenPtr(SCR_VMEM, G_HUD_0_W, 200 - G_HUD_1_H), G_HUD_1_W, G_HUD_1_H);

}

void init(){

	//Disable firmware
	cpct_disableFirmware();

    loopMusic = TRUE;

    keys.up    = Key_Q;
    keys.down  = Key_A;
    keys.left  = Key_O;
    keys.right = Key_P;
    keys.fire  = Key_Space;
    keys.pause = Key_Del;
    keys.abort = Key_Esc;

    //Initialize Music
    decompress((u8*)EXO_outlaws, (u8*)EXOBUFFER_ADDRESS);
    decompress((u8*)EXO_font, (u8*)NUMBER_ADDRESS);

    cpct_akp_musicInit(G_outlaws);
    cpct_akp_SFXInit(G_FX);

    cpct_setInterruptHandler(myInterruptHandler);

}

void drawIntro(){

	u8 end;
	u8 *pvideo = cpctm_screenPtr(SCR_VMEM, 26, 50);

	cpct_setPalette(G_graphics_palette, 16);
	cpct_setBorder(G_graphics_palette[15]);
	cpct_setVideoMode(0);

	cpct_memset(SCR_VMEM, 255, 0x4000);

	cpct_drawSprite(G_RETROBYTES, pvideo, 28, 48);

	pvideo = cpctm_screenPtr(SCR_VMEM, 28, 110);
	cpct_drawSprite(G_Presenta, pvideo, 24, 8);

	forceFrontBuffer(g_scrbuffers);

	end = FALSE;

	while(!end){

		drawDestello();
		end = cpct_isKeyPressed(keys.fire) || cpct_isKeyPressed(Joy0_Fire1);

	}

}


CPCT_RELOCATABLE_AREA();

void main(void) {

	//Cambiamos la pila de sitio
	cpct_setStackLocation((void*)0x8000);

	init();

	drawIntro();
	waitKeyUp(esperaUnaTecla());
	drawHUD();

	//Copy HUD FROM VMEM TO BUFFER
	cpct_memcpy(SCR_BUFF, SCR_VMEM, 0x4000);
	cpct_memset(SCR_VMEM, 255, 0x4000);


	//SetupVideo
	cpct_setPalette(G_graphics_palette, 16);

	outlaws();

}
